

#ifndef _PERFORMANCE_COUNTER_H_
#define _PERFORMANCE_COUNTER_H_

#include <pdh.h>
#include <pdhmsg.h>

void __CheckForError(PDH_STATUS value, char *file, int line);
#define CheckForError(a) __CheckForError(a, __FILE__, __LINE__)

#define UPDATE_ALL		0xFFFFFFFF

class CPerformanceCounter  
{
public:
	CPerformanceCounter();
	~CPerformanceCounter();

	PDH_STATUS Initialize(void);
	PDH_STATUS AddCounterFromBrowser(HWND hwnd = NULL, CString start_path = CString(), DWORD counter_format = PDH_FMT_DOUBLE);
	PDH_STATUS AddCounter(CString counter_path, DWORD counter_format = PDH_FMT_DOUBLE);
	PDH_STATUS UpdateCounter(DWORD index = UPDATE_ALL);
	inline DWORD GetNumCounters(void) { return NumCounters; }
	inline PDH_FMT_COUNTERVALUE GetCounterValue(DWORD index) { return CounterValue[index]; }
	inline CString GetCounterPath(DWORD index) { return CounterPaths[index]; }
	inline DWORD GetCounterFormat(DWORD index) { return CounterFormat[index]; }
	inline DWORD GetLastUpdate(DWORD index) { return LastUpdate[index]; }
	PDH_STATUS Reset(void);

private:

	int ResizeArrays(void);

	HQUERY					QueryHandle;
	
	DWORD					NumCounters;
	DWORD					NumAllocated;
	HCOUNTER				*CounterHandle;
	PDH_FMT_COUNTERVALUE	*CounterValue;
	CString					*CounterPaths;
	DWORD					*CounterFormat;
	DWORD					*LastUpdate;
};

#endif 